from __future__ import absolute_import

import gettext
from os import environ as os_environ

from Components.Language import language

from .settings import _PLUGIN_NAME_FOR_PATH


# myPlugin = "IwaatchFNC"


def localeInit():
    os_environ["LANGUAGE"] = language.getLanguage()[:2]
    gettext.bindtextdomain(_PLUGIN_NAME_FOR_PATH, ("/usr/lib/enigma2/python/Plugins/Extensions/" + _PLUGIN_NAME_FOR_PATH + "/locale"))


def _(txt):
    t = gettext.dgettext(_PLUGIN_NAME_FOR_PATH, txt)
    if t == txt:
        t = gettext.gettext(txt)
    return t


localeInit()
language.addCallback(localeInit)
