# -*- coding: utf-8 -*- 
# Author Franc

from .__init__ import _

from Components.config import config
from Plugins.Plugin import PluginDescriptor
from enigma import addFont

from .main import FNCmain
from .settings import _PLUGIN_NAME, _FOLDER_NAME, _PLUGIN_DESCRIPTION, _FONT_FOLDER


def main(session, **kwargs):
    session.open(FNCmain)


def menuPanel(menuid, **kwargs):
    if menuid == 'mainmenu':
        return [(_PLUGIN_NAME,
                 main,
                 _FOLDER_NAME.lower(),
                 -99)]
    else:
        return []


def Plugins(**kwargs):
    addFont(_FONT_FOLDER + 'NotoSans-Regular.ttf', 'NotoSans-Regular', 100, 0)
    addFont(_FONT_FOLDER + 'Roboto-Light.ttf', 'Roboto-Light', 100, 0)
    addFont(_FONT_FOLDER + 'Roboto-Thin.ttf', 'Roboto-Thin', 100, 0)
    addFont(_FONT_FOLDER + 'Roboto-Light.ttf', 'FNCRegular', 100, 0)
    lista = []
    if config.plugins.filemanagerfnc.ShowInExtensionList.value == True:
        lista.append(PluginDescriptor(name=_PLUGIN_NAME, description=_(_PLUGIN_DESCRIPTION), where=PluginDescriptor.WHERE_EXTENSIONSMENU, fnc=main))
    if config.plugins.filemanagerfnc.ShowInPluginList.value == True:
        lista.append(
            PluginDescriptor(name=_PLUGIN_NAME, description=_(_PLUGIN_DESCRIPTION), where=PluginDescriptor.WHERE_PLUGINMENU, icon='plugin.png', fnc=main))
    lista.append(PluginDescriptor(name=_PLUGIN_NAME, description=_(_PLUGIN_DESCRIPTION), where=PluginDescriptor.WHERE_MENU, fnc=menuPanel))
    return lista
