
from Components.Language import language
from os import environ as os_environ
from ..settings import _PLUGIN_PATH, _FOLDER_NAME
import gettext

def localeInit():
    os_environ['LANGUAGE'] = language.getLanguage()[:2]
    gettext.bindtextdomain(_FOLDER_NAME, _PLUGIN_PATH + '/locale')


def _(txt):
    t = gettext.dgettext(_FOLDER_NAME, txt)
    if t == txt:
        t = gettext.gettext(txt)
    return t


localeInit()
language.addCallback(localeInit)