#!/bin/sh
#
# 13.01.2017 - Franc (PurE2)

# WORKS in Python but can't remove 'established' with busybox(es)
#           cmd10str = 'netstat -tpn |tail +3| cut -d" " -f 16-'
# watch possible bug in tail, maybe go with sed option (slower, more memory, but if it works...) 


if tty > /dev/null ; then
   RED='-e \e[00;31m'
   GREEN='-e \e[00;32m'
   YELLOW='-e \e[01;33m'
   BLUE='-e \e[00;34m'
   PURPLE='-e \e[01;31m'
   WHITE='-e \e[00;37m'
else
   RED='\c00??0000'
   GREEN='\c0000??00'
   YELLOW='\c00????00'
   BLUE='\c0000????'
   PURPLE='\c00?:55>7'
   WHITE='\c00??????'
fi

case "$1" in
tcpinfo)
#set bold, oh yeah -  WISHFULL THINKING :)
#echo -e "\033[1m"
#set yellow
#echo -e "\033[33m"
        echo -n $BLUE
        printf "\n%s\n" "Please wait... Collecting data... \n"
        #printf "\n%s\n" "Some info about your network :"
        echo -n $YELLOW
        printf "%-24s %-24s %s\n\n" "Local Address" "Foreign Address" "PID/Program name"
#reset to normal (hopefuly...)
#echo -en "\033[0m"
# busybox version 
        netstat -tpn |tail +3|awk -F' '  '{printf "%-24s %-24s %s\n", $4, $5, $7}'
        echo -n $WHITE
        printf "\n"
# coreutils version 
#        netstat -tpn |tail --lines=+3|awk -F' '  '{printf "%-24s %-24s %s\n", $4, $5, $7}'
        ;;

general)
        echo -n $BLUE
        printf "\n%s\n" "Please be patient... Collecting data... "
        #printf "\n%s\n" "Some info about your network :"
        printf "\n%s\n" "Some info about your network : "
        echo -n $YELLOW
        privateIP=$(ifconfig |grep 'inet addr:'|grep -v '127.0.0.1'|cut -d: -f2|awk '{print$1}')
        macADR=$(ifconfig |grep 'HWaddr'| awk '{print$5}')
        mtuSIZE=$(ifconfig |grep 'CAST  MTU:'|cut -d: -f2|cut -d' ' -f1)
        rxBytes=$(ifconfig |grep 'RX bytes:'|cut -d : -f 2|cut -dT -f1|head -n 1)
        txBytes=$(ifconfig |grep 'RX bytes:'|cut -d : -f 3|head -n 1)
        gatewayIP="$(netstat -rn|grep 'UG'|awk '{print$2}')" 
        publicIP="$(wget -q -O - http://checkip.dyndns.org|sed -e 's/.*Current IP Address: //' -e 's/<.*$//')"
        ofoSEG="$(dmesg|grep 'ofo' -c)"        
#add if rx && tx == 0 we have either net down or WiFi, can be under wlan0, ra0 and some third wifi name...
        printf "\n%-35s %-20s\n"  "Local IP address is :" "$privateIP"
        printf "%-35s %-20s\n"  "Public IP address is :" "$publicIP"
        printf "%-35s %-20s\n"  "Gateway/Router IP address is :" "$gatewayIP"
        printf "%-35s %-20s\n"  "MAC of your STB is :" "$macADR"
        printf "%-35s %-20s\n"  "Received bytes so far :" "$rxBytes"
        printf "%-35s %-20s\n"  "Sent bytes so far :" "$txBytes"
        printf "%-35s %-20s\n"  "Max transmission unit :" "$mtuSIZE"
        printf "%-35s %-20s\n"  "Out of order segments :" "$ofoSEG"
        if [[ "$ofoSEG" -gt 015 ]]; then
            printf "\n%s\n" "Note: many 'Out of order segments' errors could be CCcam related."
        fi
        echo -n $WHITE
        printf "\n"
        ;;

speed)
#samples at http://www.thinkbroadband.com/download.html seem to fast and available
#set -x
#get time 
        echo -n $BLUE
        printf "%s\n" "Please be patient for a while, checking download speed"
        printf "Downloading 10MB for test... : \n"

        timeStart=$(date +%s)
#        wget -q -O/dev/null http://download.thinkbroadband.com:81/10MB.zip
        wget -q -O/dev/null http://ipv4.download.thinkbroadband.com/10MB.zip
        timeEnd=$(date +%s)
        time_diff=$(( $timeEnd - $timeStart ))
        rx_size=10485760
#does it make any sense ? If so rx_rate hold bytes/sec
        if [[ "${time_diff}" -gt 0 ]]; then
          rx_rate=$(( $rx_size / $time_diff ))
        fi
# shift by 10 bytes to get KiB/s and by 20 for MiB/s
# and print the more human readable value.
        rx_kib=$(( $rx_rate >> 10 ))
        echo -n $YELLOW
        printf "%s %i %s\n" "Approximate download speed is: $GREEN" "${rx_kib}" " KiB/second"

        echo -n $BLUE
        printf "\n%s\n" "Please be patient for a while, checking ping response..."
# Start timing again         
        timeStart=$(date +%s)
#        ping -q -w 10 google.de > "/tmp/pResult.tmp"           
        ping -q -w 10 google.de > "/tmp/pResult.tmp"           
#        cat "/tmp/pResult.tmp"|tail --lines=+3
        echo -n $YELLOW
        cat "/tmp/pResult.tmp"|tail -n +3
        gatewayIP="$(netstat -rn|grep 'UG'|awk '{print$2}')"
        echo -n $BLUE
        printf "\n%s\n" "Checking ping to your router ..."
        echo -n $YELLOW
        ping -q -w 5 "$gatewayIP" > "/tmp/pResult.tmp"
#        cat "/tmp/pResult.tmp"|tail --lines=+3
        cat "/tmp/pResult.tmp"|tail -n  +3

        rm "/tmp/pResult.tmp"

#        timeEnd=$(date +%s)
#        time_diff=$(( $timeEnd - $timeStart ))
#        rx_rate=$(( $rx_size / $time_diff ))
#        rx_kib=$(( $rx_rate >> 10 ))
#        printf "%s %i %s\n" "Approximate download speed for mesured while pinging is: " "${rx_kib}" " KiB/second"
        echo -n $WHITE
        printf "\n"
        ;;

misc)
        printf "%-24s %-24s %s\n\n" "Not used" "at the moment" "dummy placeholder" 
        ;;
        
esac

