# -*- coding: utf-8 -*-

from __future__ import absolute_import
__author__ = "mx3L"
__email__ = "mx3Lmail@gmail.com"
__copyright__ = 'Copyright (c) 2014 mx3L'
__license__ = "GPL-v2"
__version__ = "3.1-pure2"

import gettext
import os

from Components.Language import language
from Tools.Directories import resolveFilename, SCOPE_LANGUAGE


def localeInit():
    lang = language.getLanguage()
    os.environ["LANGUAGE"] = lang[:2]
    gettext.bindtextdomain("enigma2", resolveFilename(SCOPE_LANGUAGE))
    gettext.textdomain("enigma2")
    gettext.bindtextdomain("SubsSupport", os.path.join(os.path.dirname(__file__), 'locale'))


def _(txt):
    t = gettext.dgettext("SubsSupport", txt)
    if t == txt:
        t = gettext.gettext(txt)
    return t


localeInit()
language.addCallback(localeInit)

from .subtitles import SubsSupport, SubsSupportStatus, initSubsSettings




# =========================================================
# BACKWARD COMPATIBILITY - za stari naziv fajla: process.py
# =========================================================
import sys
from . import subsprocess

# Preusmjeri sve zahtjeve sa starog 'process.py' na novi 'subsprocess.py'
class _ProcessCompat:
    def __getattr__(self, name):
        # Kada netko traži atribut iz 'process.py' modula, vrati ga iz 'subsprocess.py'
        return getattr(subsprocess, name)

# Kreiraj instancu i registriraj je u Python sistemu
# Ovo omogućava da: from Plugins.Extensions.SubsSupport.process import SubsLoader, itd i dalje radi
sys.modules['Plugins.Extensions.SubsSupport.process'] = _ProcessCompat()